function out=icrIPmat(data)
% This is the inverse of the crIPmat. Data is a square CxC matrix with
% zeros below the main antidiagonal.
% for example a 3x3 matrix with rows as follows
% data(:,1)=[2 3 4]
% data(:,2)=[5 6 0]
% data(:,3)=[7 0 0]
% is a type of matrix that this function is written for
% icrIPmat transforms this matrix to a vector row wise, by taking only the
% elements above the main antidiagonal
% thus for this matrix data, the output of the function is the following
% vector: out=[2 3 4 5 6 7]
C=size(data,2);
out=ones(size(C+1));
for i=1:C+1
    out(i,i)=1;
    for j=i+1:C+1
    out(i,j)=data(i,j-i);
    out(j,i)=out(i,j);
    end
end
out=vecl(out);




